# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name IO-FDSaver
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Save file descriptors from Perl.s garbage collection.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FE/FELIPE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Perl.e's ability to create a filehandle from a given file descriptor
is critical for advanced IPC functionality like accepting a file descriptor
across an `exec()' or via UNIX socket (i.e., SCM_RIGHTS).

It.e's also useful when interfacing with C libraries (i.e., via XSUBs), but
in this context there.e's a catch: Perl expects to .e'own.e' all of its file
handles.e' file descriptors. So if Perl garbage-collects its last file handle
that refers to a given file descriptor, Perl will close that file descriptor.
Thus, your C code.eiwhich has no idea there.e's this Perl thing calling into
it.eiwill suddenly start getting EBADF when trying to use its file
descriptors. These errors can be confusing and time-consuming to fix.

The present module solves this problem by retaining an index of file descriptors
and Perl file handles. As long as a given instance of this class survives,
Perl will never auto-close the file descriptors given to that object
because there will always remain at least one file handle that refers to each
file descriptor.

(NB: File descriptors *not* given to such an object will behave as usual.)

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE
%perl_vendor_privlib/I*

%changelog
