# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(Encode.pm) perl(ExtUtils/CBuilder.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    IP-QQWry
%define upstream_version 0.0.21

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    A simple interface for QQWry IP database(file)
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/IP/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(version.pm)
BuildArch:  noarch
Source44: import.info

%description
'QQWry.Dat' http://www.cz88.net/fox/ is an IP file database. It
provides some useful information such as the geographical position of the
host bound with some IP address, the IP's owner, etc. IP::QQWry
provides a simple interface for this file database.

For more about the format of the database, take a look at this:
http://lumaqq.linuxsir.org/article/qqwry_format_detail.html

Caveat: The 'QQWry.Dat' database uses gbk or big5 encoding, 'IP::QQWry'
doesn't provide any encoding conversion utility, so if you want some other
encoding, you have to do it yourself. (BTW, Encode is a great
module for this.)

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml  README
%perl_vendor_privlib/*


%changelog
