# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Color/Scheme.pm) perl(Config.pm) perl(Cwd.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Find/Rule.pm) perl(File/ShareDir.pm) perl(File/Slurp.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(GD.pm) perl(GD/Text/Align.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Math/PlanePath/TheodorusSpiral.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Params/Validate.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Image-WordCloud
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Create word cloud images
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BH/BHANN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use Image::WordCloud;
_use File::Slurp;
_
_my $wc = Image::WordCloud->new();
_
_# Add the Gettysburg Address
_my $text = read_file('script/gettysburg.txt');
_$wc->words($text);
_
_# Create the word cloud as a GD image
_my $gd = $wc->cloud();
_
_open(my $fh, '>', 'gettysburg.png');
__binmode $fh;
__print $fh $gd->png();
_close($fh);
_
_# See examples/gettysburg.png for how the created image looks.
_# script/gettysburg.pl will create it
_
_# The calls can also be chained like so:
_my $text = read_file('script/gettysburg.txt');
_my $gd = Image::WordCloud->new()
__->words($text)
__->cloud();

Create "word cloud" images from a set of specified words, similar to http://wordle.net.
Font size indicates the frequency with which a word is used.

Colors are generated randomly using the Color::Scheme manpage. Fonts can be specified or chosen randomly.

%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes TODO README examples
%perl_vendor_privlib/I*
%perl_vendor_privlib/auto/*
%changelog
