%define module_name JSON-RPC2-AnyEvent-Client
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(AnyEvent/HTTP.pm) perl(AnyEvent/HTTPD.pm) perl(AnyEvent/Handle.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON/RPC2/AnyEvent.pm) perl(JSON/RPC2/AnyEvent/Server.pm) perl(JSON/RPC2/AnyEvent/Server/Handle.pm) perl(JSON/RPC2/Client.pm) perl(JSON/XS.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(version.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Asynchronous nonblocking JSON RPC2 client with method mapping
Group: Development/Perl
License: perl
URL: https://github.com/oklas/p5-JSON-RPC2-AnyEvent-Client

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OK/OKLAS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
JSON::RPC2::AnyEvent::Client is JSON RPC2 client, with
tcp/http/https transport. Remote functions is mapped to local
client object methods. For example remote function fn(...) is
called as $c->fn(...,cb). Params of function is params of remote
functions with additional one at the end of param list.
Additional last param is result handler soubroutine.

Implementation is based on JSON RPC2 implementation
the JSON::RPC2::Client manpage. Transport implementation is based
on the AnyEvent::Handle manpage for tcp, and on the AnyEvent::HTTP manpage
for http/https.

The 'tcp' implementation use persistent connection, that make
tcp connection at object creation and use it all object life time.
The http/https persistence is AnyEvent::HTTP implementation
dependent and currently it is not persistent for idempotent
requsests (JSON RPC2 need POST requset). See description of
'persistent' and 'keepalive' params of the AnyEvent::HTTP manpage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/J*

%changelog
