# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Load.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON/Parse.pm) perl(JSON/Validator.pm) perl(List/Util.pm) perl(Pod/Coverage/TrustPod.pm) perl(SQL/Maker/Select.pm) perl(SQL/QueryMaker.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(base.pm) perl(diagnostics.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name JsonSQL
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.41
Release: alt1
Summary: Defines a JSON format to represent SQL queries which can be validated and then used to generate SQL...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HO/HOEFLERB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The purpose of this distribution is to provide a reasonably safe mechanism for SQL query generation using data from untrusted sources, namely
web browsers. JSON is a convenient format native to JavaScript (ECMAScript), which can be translated to and from Perl objects fairly easily. 
JSON was selected to provide a structured format for representing SQL statements such that it can be validated, checked for appropriate
access restrictions, and used to generate a well-formed and parameterized SQL statement that can be passed off to the the DBI manpage module.

The format is somewhat verbose in a few places, with the idea that the user/developer needs to be very explicit when passing parameters
to the query. This makes it well-suited for handling untrusted data (for example, from HTML forms), but if you just need a basic SQL
generator, you would probably be better off looking at the SQL::Abstract manpage or the SQL::Maker manpage instead.

A simple SELECT statement,

    {
        "fields": [
            {"column": "*"}
        ],
        "from": [
            {"table": "my_table"}
        ]
    }

A more complicated SELECT statement,

    {
        "fields": [
            {"column": "field1"},
            {"column": "field2", "alias": "test"}
        ],
        "from": [
            {"table": "table1", "schema": "MySchema"}
        ], 
        "where": {
            "and": [
                { "eq": {"field": {"column": "field2"}, "value": "Test.Field2"} },
                { "eq": {"field": {"column": "field1"}, "value": "453.6"} },
                { "or": [
                    { "eq": {"field": {"column": "field2"}, "value": "field3"} },
                    { "gt": {"field": {"column": "field3"}, "value": "45"} }
                ]}
            ]
        }
    }

A SELECT statement with JOINs,

    {
        "fields": [
            {"column": "field1"},
            {"column": "field2", "alias": "test"}
        ],
        "joins": [
            {"jointype": "inner", "from": {"table": "table1", "schema": "MySche...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/J*

%changelog
