%define module_name Keyword-Declare
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B/Hooks/EndOfScope.pm) perl(Data/Dump.pm) perl(ExtUtils/MakeMaker.pm) perl(Inline.pm) perl(Keyword/Simple.pm) perl(Lingua/Romana/Perligata.pm) perl(List/Util.pm) perl(PPI.pm) perl(PPR.pm) perl(Test/More.pm) perl(Types/Standard.pm) perl(Variable/Magic.pm) perl(experimentals.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001018
Release: alt1
Summary: Declare new Perl keywords...via a keyword...named C<keyword>
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DC/DCONWAY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module implements a new Perl keyword: `keyword', which you can
use to specify other new keywords.

Normally, to define new keywords in Perl, you either have to write them
in XS (shiver!) or use a module like the Keyword::Simple manpage or
the Keyword::API manpage. Using any of these approaches requires you to grab all
the source code after the keyword, manually parse out the components of
the keyword's syntax, construct the replacement source code, and then
substitute it for the original source code you just parsed.

Using Keyword::Declare, you define a new keyword by specifying its name
and a parameter list corresponding to the syntactic components that must
follow the keyword. You then use those parameters to construct and
return the replacement source code. The module takes care of setting up
the keyword, and of the associated syntax parsing, and of inserting the
replacement source code in the correct place.

For example, to create a new keyword (say: `loop') that takes an optional
count and a block, you could write:

    use Keyword::Declare;

    keyword loop (Int $count?, Block $block) {
        if (defined $count) {
            return "for (1..$count) $block";
        }
        else {
            return "while (1) $block";
        }
    }

At compile time, when the parser subsequently encounters source
code such as:

    loop 10 {
        $cmd = readline;
        last if valid_cmd($cmd);
    }

then the keyword's $count parameter would be assigned the value `"10"'
and its $code parameter would be assigned the value
`"{\n$cmd_=_readline;\nlast_if_valid_cmd($cmd);\n}"'. Then the "body" of
the keyword definition would be executed and its return value would be used as the
replacement source code:

    for (1..10) {
        $cmd = readline;
        last if valid_cmd($cmd);
    }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/K*

%changelog
