Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(Data/Hexdumper.pm) perl(Perl/Tidy.pm) perl(Plucene.pm) perl(Plucene/Analysis/WhitespaceAnalyzer.pm) perl(Plucene/Document.pm) perl(Plucene/Document/Field.pm) perl(Plucene/Index/Writer.pm) perl(Text/Diff.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-KinoSearch1
Version:        1.01
Release:        alt15_40
Summary:        Search engine library
# ApacheLicense2.0.txt included is included just becuase the upstream
# author decided to include it and is only for informative purposes.
# We believe that it doesn't apply, since author didn't use any Lucene
# code (according to mail in LICENSING.mbox)
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/KinoSearch1
Source0:        https://cpan.metacpan.org/authors/id/C/CR/CREAMYG/KinoSearch1-%{version}.tar.gz
# Make regular expressions compatible with Perl 5.24.0, CPAN RT#105144
Patch0:         KinoSearch1-1.01-Do-not-use-C-in-regexps.patch
Source1:        LICENSING.mbox
# Build
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/CBuilder.pm)
BuildRequires:  perl(Fcntl.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(Storable.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Runtime
BuildRequires:  perl(base.pm)
BuildRequires:  perl(bytes.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Compress/Zlib.pm)
BuildRequires:  perl(constant.pm)
# BuildRequires:  perl(Data::Dumper)
BuildRequires:  perl(Digest/MD5.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(IO/Select.pm)
BuildRequires:  perl(IO/Socket/INET.pm)
BuildRequires:  perl(Lingua/Stem/Snowball.pm)
BuildRequires:  perl(Lingua/StopWords.pm)
BuildRequires:  perl(locale.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Time/HiRes.pm)
BuildRequires:  perl(XSLoader.pm)
# Tests only
# XXX: BuildRequires:  perl(Config)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/stat.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(List/Util.pm)
# XXX: BuildRequires:  perl(Plucene)
# XXX: BuildRequires:  perl(Plucene::Analysis::WhitespaceAnalyzer)
# XXX: BuildRequires:  perl(Plucene::Document)
# XXX: BuildRequires:  perl(Plucene::Document::Field)
# XXX: BuildRequires:  perl(Plucene::Index::Writer)
# XXX: BuildRequires:  perl(POSIX)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Data/Dumper.pm)
Requires:       perl(Lingua/Stem/Snowball.pm) >= 0.940
Requires:       perl(Lingua/StopWords.pm) >= 0.020



Source44: import.info
%filter_from_requires /^perl(Lingua.Stem.Snowball.pm)/d
%filter_from_requires /^perl(Lingua.StopWords.pm)/d


%description
KinoSearch1 is a loose port of the Java search engine library Apache
Lucene, written in Perl and C. The archetypal application is website
search, but it can be put to many different uses.

%prep
%setup -q -n KinoSearch1-%{version}
%patch0 -p1
cp %{SOURCE1} LICENSING.mbox

%build
perl Build.PL installdirs=vendor optimize="%{optimize}"
./Build

%install
./Build install destdir=%{buildroot} create_packlist=0
find %{buildroot} -type f -name '*.bs' -size 0 -exec rm -f {} +
# %{_fixperms} %{buildroot}/*

%check
./Build test

%files
%doc --no-dereference ApacheLicense2.0.txt LICENSING.mbox
%doc buildlib Changes README
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/*

%changelog
