%define module_name Log-ger-Plugin-OptAway
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B/CallChecker.pm) perl(B/Generate.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Log/ger.pm) perl(Log/ger/Output.pm) perl(Log/ger/Plugin.pm) perl(Log/ger/Util.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.009
Release: alt1
Summary: Optimize away higher-level log statements
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Log-ger-Plugin-OptAway

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin replaces logging statements that are higher than the current level
(`$Log::ger::Current_Level') into a no-op statement using the B::CallChecker manpage
magic at compile-time. The logging statements will become no-op and will have
zero run-time overhead.

By default, since `$Current_Level' is pre-set at 3 (warn) then `log_info()',
`log_debug()', and `log_trace()' calls will be turned into no-op.

Caveats:

=over

=item * must be done at compile-time

=item * only works when you are using procedural style

=item * once optimized away, subsequent logger reinitialization at run-time won't take effect

=back

=for Pod::Coverage ^(.+)$
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/L*

%changelog
