# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(DBD/SQLite.pm) perl(DBI.pm) perl(SQL/Abstract.pm) perl(Sort/Key.pm) perl(Sort/Key/Natural.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    MP3-Find
%define upstream_version 0.07

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    File::Find-based backend to MP3::Find
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/MP3/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(MP3/Info.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildArch: noarch
Source44: import.info

%description
This module allows you to search for MP3 files by their ID3 tags. You can
ask for the results to be sorted by one or more of those tags, and return
either the list of filenames (the default), a 'printf'-style formatted
string for each file using its ID3 tags, or the actual Perl data structure
representing the results.

There are currently two backends to this module: MP3::Find::Filesystem
and MP3::Find::DB. You choose which one you want by
passing its name as the argument to you 'use' statement; *MP3::Find* will
look for a *MP3::Find::$BACKEND* module. If no backend name is given, it
will default to using MP3::Find::Filesystem.

*Note:* I'm still working out some kinks in the DB backend, so it is
currently not as stable as the Filesystem backend.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml README
%perl_vendor_privlib/*
/usr/bin/mp3db
/usr/bin/mp3find
%{_mandir}/man1/mp3db.1*
%{_mandir}/man1/mp3find.1*



%changelog
