%define module_name Mail-DMARC-Iterator
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Socket/SSL/PublicSuffix.pm) perl(Mail/DKIM/Iterator.pm) perl(Mail/SPF/Iterator.pm) perl(Net/DNS.pm) perl(Scalar/Util.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.014
Release: alt1
Summary: validate mails against DMARC policy the asynchronous way
Group: Development/Perl
License: perl
URL: https://github.com/noxxi/p5-mail-dmarc-iterator

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SU/SULLR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module can be used to validate mails against DMARC policies like specified
in RFC 7208.
The main difference to the Mail::DMARC manpage is that it does no blocking operations.
Instead it implements a state machine where user input is fed into and
instructions what the machine wants is returned. 
The state machine only wants the data from the mail and the result of specific
DNS lookups. With each new data fed into the machine it will provide new
information what it needs next, until it finally has enough input and returns
the final result.
Because of this design the DMARC policy validation can be easily integrated into
event-driven programs or coupled with a specific DNS resolver. 

the Mail::DMARC::Iterator manpage uses the similarly designed modules
the Mail::DKIM::Iterator manpage and the Mail::SPF::Iterator manpage to provide the necessary
functionality of validating against DKIM and SPF records.

the Mail::DMARC::Iterator manpage currently only validates a mail against the policy. It
does not provide any kind of feedback to the owner of the domain, i.e. feedback
based on the `ruf' and `rua' attributes of the DMARC policy is not
implemented. One can still access the necessary information using the `record'
method.

The following methods are implemented

=over 4

=item $class->new(%%args) -> $dmarc

This creates a new object. The following arguments can be given:

=over 8

=item mailfrom, ip, helo, myname

These arguments are given to the the Mail::SPF::Iterator manpage object where they will
be used to compute the SPF policy.

=item spf_received => \@spf_result | undef

In this record the final result of the SPF policy calculation can be given as
described in the Mail::SPF::Iterator manpage. If the argument is given and set to undef
it will try to find `Received-SPF' records inside the mail extract the SPF
result from them. These records must have an `envelope-from' parameter which
will be used for identity aligning as described in the DMARC specification.

=item dkim_result => DKIM_RESULT

If given...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
