# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/HMAC_SHA1.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(IO/Select.pm) perl(IO/Socket.pm) perl(MLDBM.pm) perl(Test/More.pm) perl(base.pm) perl(blib.pm)
# END SourceDeps(oneline)
%define module_version 0.31
%define module_name Mail-SRS
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.31
Release: alt1
Summary: Interface to Sender Rewriting Scheme
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SH/SHEVEK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The Sender Rewriting Scheme preserves .forward functionality in an
SPF-compliant world.

SPF requires the SMTP client IP to match the envelope sender
(return-path). When a message is forwarded through an intermediate
server, that intermediate server may need to rewrite the return-path
to remain SPF compliant. If the message bounces, that intermediate
server needs to validate the bounce and forward the bounce to the
original sender.

SRS provides a convention for return-path rewriting which allows
multiple forwarding servers to compact the return-path. SRS also
provides an authentication mechanism to ensure that purported bounces
are not arbitrarily forwarded.

SRS is documented at http://spf.pobox.com/srs.html and many points
about the scheme are discussed at http://www.anarres.org/projects/srs/

For a better understanding of this code and how it functions, please
read this document and run the interactive walkthrough in eg/simple.pl
in this distribution. To run this from the build directory, type
"make teach".

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README TODO README.pobox
%perl_vendor_privlib/M*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
