%define module_name Mic
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Method/Modifiers.pm) perl(Config/Tiny.pm) perl(List/MoreUtils.pm) perl(Module/Build/Tiny.pm) perl(Module/Runtime.pm) perl(Package/Stash.pm) perl(Params/Validate.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Sub/Name.pm) perl(Test/Lib.pm) perl(Test/Most.pm) perl(Test/Output.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001004
Release: alt1
Summary: Messages, Interfaces and Contracts.
Group: Development/Perl
License: gpl
URL: https://github.com/arunbear/Mic

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AR/ARUNBEAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Mic is an OOP automation framework with the following features:

=over

=item *

Reduces the tedium and boilerplate code typically involved in creating object oriented modules.

=item *

Makes it easy to create classes that are modular and loosely coupled.

=item *

Enables trivial swapping of implementations (see the Mic::Bind manpage).

=item *

Encourages self documenting code.

=item *

Encourages robustness via Eiffel style contracts.

=back


Modularity means there is an obvious separation between what the users of an object need to know (the interface for using the object) and implementation details that users
don't need to know about.

This separation of interface from implementation details is an important aspect of modular design, as it enables modules to be interchangeable (so long as they have the same interface).

It is not a coincidence that the Object Oriented concept as originally envisioned was mainly concerned with messaging,
where in the words of Alan Kay (who coined the term "Object Oriented Programming") objects are "like biological cells and/or individual computers on a network, only able to communicate with messages"
and "OOP to me means only messaging, local retention and protection and hiding of state-process, and extreme late-binding of all things."
(see The Deep Insights of Alan Kay).

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/M*

%changelog
