# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Mojo/Base.pm) perl(Mojolicious.pm) perl(Mojolicious/Lite.pm) perl(Test/Mojo.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Mojolicious-Plugin-ErrorsAndWarnings
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Store errors & warnings during a request
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/K/KW/KWAKWA/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
the Mojolicious::Plugin::ErrorsAndWarnings manpage is a basic plugin for the Mojolicious manpage
which provides helpers to store and retrieve user-defined errors and warnings.
This is particularly useful to help collect errors and warnings from within
multiple method calls during a request cycle. At the end of the request, the
error and warning objects provide additional information about any problems
encountered while performing an operation.

Adding errors or warnings will store them under the Mojolicious stash key `plugin.errors' by default. Don't
access this stash value directly. Use the `$c->errors' and
`$c->warnings' accessors instead.

  # add errors and warnings using the imported helpers
  $c->add_error('first_error');
  $c->add_warning('first_warning');

  # {"errors":[{"code":"first_error"}], "warnings":[{"code":"first_warning"}]}
  $c->render(json => {errors => $c->errors, warnings => $c->warnings});

The first argument to the add_error entry elsewhere in this document or the add_warning entry elsewhere in this document is referred to as the
`code'. This an application-specific error or warning code, expressed as a
string value.

  $c->add_error('sql', status => 400, title => 'Your SQL is malformed.');
  $c->add_warning('search', title => 'Invalid search column.', path => 'pw');

  # {
  #    "errors": [
  #        {
  #            "code": "sql",
  #            "status": 400,
  #            "title": "Your SQL is malformed."
  #        }
  #    ],
  #    "warnings": [
  #        {
  #            "code": "search",
  #            "path": "password",
  #            "title": "Invalid search column."
  #        }
  #    ]
  # }
  $c->render(json => {errors => $c->errors, warnings => $c->warnings});

Additional members can be added to provide more specific information about the
problem. See also http://jsonapi.org/format/#errors for examples of other
members you might want to use.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/M*

%changelog
