%define module_name Neo4j-Driver
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Headers.pm) perl(HTTP/Response.pm) perl(JSON/MaybeXS.pm) perl(JSON/PP.pm) perl(LWP/UserAgent.pm) perl(Mock/Quick.pm) perl(Neo4j/Error.pm) perl(Neo4j/Types.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Neo4j/Types.pm) perl(Test/Warnings.pm) perl(Time/Piece.pm) perl(Try/Tiny.pm) perl(URI.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.46
Release: alt1
Summary: Perl implementation of the Neo4j Driver API
Group: Development/Perl
License: artistic_2
URL: https://github.com/johannessen/neo4j-driver-perl

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AJ/AJNN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is an unofficial Perl implementation of the
Neo4j Driver API.
It enables interacting with a Neo4j database server using more or
less the same classes and method calls as the official Neo4j drivers
do. Responses from the Neo4j server are passed through to the client
as-is.

This driver extends the uniformity across languages, which is a
stated goal of the Neo4j Driver API, to Perl. The downside is that
this driver doesn't offer fully-fledged object bindings like the
existing the REST::Neo4p manpage module does. Nor does it offer any the DBI manpage
integration. However, it avoids the legacy `cypher' endpoint,
assuring compatibility with future Neo4j versions.

This software has pre-release quality. There is no schedule for
further development. The interface is not yet stable.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/N*
%perl_vendor_privlib/U*

%changelog
