%define module_name Neo4j-Types
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Tester.pm) perl(Test/Warnings.pm) perl(if.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.00
Release: alt1
Summary: Common Neo4j type system
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AJ/AJNN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The packages in this distribution offer a Neo4j type system for Perl.
Other distributions for the Neo4j ecosystem such as the Neo4j::Bolt manpage
and the Neo4j::Driver manpage can (if they so choose) use these packages
either directly or indirectly.

If several such distributions share the same representation of Neo4j
values, sharing data between distributions becomes more efficient and
users may have an easier time alternating between them.

Packages in this distribution primarily define methods. They do not
currently make any particular assumptions about their internal data
structures. This distribution offers default implementations of the
methods it defines; these are designed to work with the Neo4j::Bolt manpage
data structures. But inheritors (such as `Local::Node' in the
synopsis example) are free to use any data structure they like,
provided they override methods as required to not change the API.

The methods defined by this distribution are loosely modelled
on the Neo4j Driver API. They don't match that API precisely
because the official Neo4j drivers don't always use the exact
same method names for their functionality, and the
Neo4j Driver API Spec
currently doesn't discuss these methods.

The module the Neo4j::Types manpage itself currently only contains
documentation, but you can `use' it as a shortcut to make all
modules that are included in this distribution available to you.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/N*
%perl_vendor_privlib/T*

%changelog
