# BEGIN SourceDeps(oneline):
BuildRequires: perl(Future/Utils.pm) perl(HTTP/Cookies.pm) perl(HTTP/Request.pm) perl(HTTP/Response.pm) perl(HTTP/Status.pm) perl(IO/Async.pm) perl(JSON.pm) perl(Log/Log4perl.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/Async/HTTP.pm) perl(Net/DNS.pm) perl(Test/CheckManifest.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod/Coverage.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Net-Async-DigitalOcean
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Async client for DigitalOcean REST APIv2
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DR/DRRHO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use IO::Async::Loop;
    my $loop = IO::Async::Loop->new;      # the god-like event loop

    use Net::Async::DigitalOcean;
    my $do = Net::Async::DigitalOcean->new( loop => $loop );
    $do->start_actionables;               # activate polling incomplete actions

    # create a domain, wait for it
    $do->create_domain( {name => "example.com"} )
       ->get;   # block here

    # create a droplet, wait for it
    my $dr = $do->create_droplet({
_"name"       => "www.example.com",
_"region"     => "nyc3",
_"size"       => "s-1vcpu-1gb",
_"image"      => "openfaas-18-04",
_"ssh_keys"   => [],
_"backups"    => 'true',
_"ipv6"       => 'true',
_"monitoring" => 'true',
____  })
       ->get; $dr = $dr->{droplet}; # skip type

    # reboot
    $do->reboot(id => $dr->{id})->get;
    # reboot all droplets tagged with 'prod:web'
    $do->reboot(tag => 'prod:web')->get;

    

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc USAGE Changes README.md examples
%perl_vendor_privlib/N*

%changelog
