Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Net-DBus-GLib
Version:        0.33.0
Release:        alt14_46
Summary:        Perl extension for the DBus GLib bindings
License:        GPL-2.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Net-DBus-GLib
Source0:        https://cpan.metacpan.org/authors/id/D/DA/DANBERR/Net-DBus-GLib-%{version}.tar.gz
# Build
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Runtime
BuildRequires:  libdbus-devel
BuildRequires:  libdbus-glib-devel
BuildRequires:  perl(Glib.pm)
BuildRequires:  perl(Net/DBus.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XSLoader.pm)
# Tests only
BuildRequires:  perl(Test/More.pm)
# Optional tests only
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
Requires:       perl(Net/DBus.pm) >= 0.33.0
Requires:       perl(XSLoader.pm)


Source44: import.info
%filter_from_requires /^perl(Net.DBus.pm)/d

%description
Net::DBus::GLib provides an extension to the Net::DBus module allowing
integration with the GLib mainloop. To integrate with the main loop, simply
get a connection to the bus via the methods in Net::DBus::GLib rather than
the usual Net::DBus module. That's it - every other API remains the same.

%prep
%setup -q -n Net-DBus-GLib-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="%{optflags}" NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -size 0 -delete
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc AUTHORS CHANGES README examples/
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/Net*

%changelog
