%define module_version 0.02
%define module_name Net-Tomcat
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(LWP.pm) perl(Test/More.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: A Perl API for monitoring Apache Tomcat.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/L/LT/LTP/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Net::Tomcat is a Perl API for monitoring Apache Tomcat instances.

        use Net::Tomcat;

        # Create a new Net::Tomcat object
        my $tc = Net::Tomcat->new(
                                username => 'admin',
                                password => 'password',
                                hostname => 'web-server-01.company.com'
                              ) 
                or die "Unable to create new Net::Tomcat object: $!\n";

        # Print the Tomcat server version and JVM version information
        print "Tomcat version: " . $tc->server->version . "\n"
            . "JVM version: " . $tc->server->jvm_version . "\n";

        # Get all connectors as an array of Net::Tomcat::Connector objects
        my @connectors = $tc->connectors;

        # Print the connector names, and request and error counts
        foreach my $connector ( @connectors ) {
                print "Name: " . $connector->name . "\n"
                    . "Request Count: ".$connector->request_count . "\n"
                    . "Error Count: ".$connector->error_count . "\n\n"
        }

        # Directly access a connector by name
        print "http-8080 error count: " 
                . $tc->connector('http-8080')->stats->error_count . "\n";

_# Retrieve a Net::Tomcat::Connector::Scoreboard object
_# representing the request scoreboard of the connector.
_my $scoreboard = $tc->connector('http-8080')->scoreboard;

_# Get all threads in a servicing state as 
_# Net::Tomcat::Connector::Scoreboard::Entry objects.
_my @threads = $scoreboard->threads_service;
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.md
%perl_vendor_privlib/N*

%changelog
