Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(POE/Component/SSLify.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-POE-Component-Client-Keepalive
%global real_ver 0.272
# Keep four digits to stay above the unfortunate 0.0901,
# so that epoch need not be changed.
Version:        %{real_ver}0
Release:        alt2_29
Summary:        Manages and keeps alive client connections
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/POE-Component-Client-Keepalive
Source0:        https://cpan.metacpan.org/authors/id/R/RC/RCAPUTO/POE-Component-Client-Keepalive-%{real_ver}.tar.gz
# Fix a race in t/10_resolver.t, bug #1136851, CPAN RT#98644
Patch0:         POE-Component-Client-Keepalive-0.272-Fix-a-race-in-t-10_resolver.t.patch
BuildArch:      noarch
# Build
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Runtime
BuildRequires:  perl(bytes.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Errno.pm)
BuildRequires:  perl(Net/IP/Minimal.pm)
BuildRequires:  perl(POE.pm)
BuildRequires:  perl(POE/Component/Resolver.pm)
BuildRequires:  perl(POE/Component/Server/TCP.pm)
# Unused BuildRequires:  perl(POE::Component::SSLify)
BuildRequires:  perl(POE/Wheel/ReadWrite.pm)
BuildRequires:  perl(POE/Wheel/SocketFactory.pm)
BuildRequires:  perl(Socket.pm)
# Tests
BuildRequires:  perl(IO/Socket/INET.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Net/IP/Minimal.pm) >= 0.020
Requires:       perl(POE.pm) >= 1.311
Requires:       perl(POE/Component/Resolver.pm) >= 0.917
# Satisfy automaticly generated requires that want this module >= 0.0901
# (So the package has this provide in two versions, oh well.)
Provides:       perl(POE/Component/Client/Keepalive.pm) = %{version}





Source44: import.info
%filter_from_requires /:__requires_exclude\|^}perl(Net.IP.Minimal.pm)/d
%filter_from_requires /^perl(POE.pm)/d
%filter_from_requires /^perl(POE.Component.Resolver.pm)/d

%description
POE::Component::Client::Keepalive creates and manages connections for other
components. It maintains a cache of kept-alive connections for quick reuse. It
is written specifically for clients that can benefit from kept-alive
connections, such as HTTP clients. Using it for one-shot connections would
probably be silly.

%prep
%setup -q -n POE-Component-Client-Keepalive-%{real_ver}
%patch0 -p1
chmod -c -x mylib/* t/*
for test in t/release-pod-syntax.t \
            t/release-pod-coverage.t \
            t/000-report-versions.t; do
    perl -MConfig -i -pe 's/#!perl/$Config{startperl}/' ${test}
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
# I'm leaving all tests active for now, even though 09_timeout.t runs a test
# which is _supposed_ to timeout against google.com.  This may or may not
# work inside the buildsys; if it doesn't the cure should be as easy as nixing
# this one test.
unset RELEASE_TESTING
make test

%files
%doc --no-dereference LICENSE
%doc CHANGES README
%{perl_vendor_privlib}/*

%changelog
