Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Perl-Critic-Itch
Version:        0.07
Release:        alt2_34
Summary:        Collection of Perl::Critic policies to solve some itches
License:        GPLv3+ or Artistic 2.0
URL:            https://metacpan.org/release/Perl-Critic-Itch
Source0:        https://cpan.metacpan.org/authors/id/M/MA/MARCELO/Perl-Critic-Itch-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Perl/Critic.pm)
BuildRequires:  perl(Perl/Critic/Policy.pm)
BuildRequires:  perl(Perl/Critic/Utils.pm)
# Tests only
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Perl/Critic/TestUtils.pm)
BuildRequires:  perl(Perl/Critic/Violation.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
Requires:       perl(Perl/Critic.pm) >= 1.052
Requires:       perl(Perl/Critic/Utils.pm) >= 1.052

# Remove underspecified dependencies

Source44: import.info
%filter_from_requires /^perl(Perl.Critic.Utils.pm)/d

%description
Perl::Critic::Itch was created to fulfill some special requests when analyzing
Perl Code. This policies, may not be useful to everyone, and surely not
consensual, but they solve some little itches I had, and it makes me sleep
better at night!

%prep
%setup -q -n Perl-Critic-Itch-%{version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
