# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Build.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Utils.pm) perl(Pod/Coverage/TrustPod.pm) perl(Readonly.pm) perl(Test/CPAN/Changes.pm) perl(Test/CPAN/Meta/JSON.pm) perl(Test/Fatal.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define module_name Perl-Critic-Policy-InputOutput-ProhibitHighPrecedentLogicalOperatorErrorHandling
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: prohibits logical error handling in open statements
Group: Development/Perl
License: artistic_2
URL: https://github.com/jonasbn/perl-critic-policy-inputoutput-prohibitlogicaloperatorerrorhandling

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JO/JONASBN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This policy addresses an anti-pattern and possible bug. If you use `open' combined with the high precedence logical or operator `||' for error handling.

If the file parameter is pointing to a non-existent file, the use of a high precedence logical operator `||', does not short-cut as expected. This implies that the bug only is present if the file does not exist. If the file exists, but cannot be opened the error handling is not working as expected.

    open my $fh, '<', $file
            || die "Can't open '$file': $!"; # not okay

    open(my $fh, '<', $file)
        || die "Can't open '$file': $!"; # okay

    open my $fh, '<', $file
        or die "Can't open '$file': $!"; # okay

    open my $fh, "<$file"
            || die "Can't open '$file': $!"; # not okay

    open(my $fh, "<$file")
        || die "Can't open '$file': $!"; # okay

    open my $fh, "<$file"
        or die "Can't open '$file': $!"; # okay

The remedy is to use parentheses for `open' or the lower precedence logical operator `or'.

Alternatively autodie can be used,

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CODE_OF_CONDUCT.md Changes README CONTRIBUTING.md LICENSE
%perl_vendor_privlib/P*

%changelog
