Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global libname Perlbal-XS-HTTPHeaders
Name:           perl-%{libname}
Version:        0.20
Release:        alt13_48
Summary:        Perlbal extension for processing HTTP headers
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/%{libname}
Source0:        https://cpan.metacpan.org/authors/id/D/DO/DORMANDO/%{libname}-%{version}.tar.gz
BuildRequires:  findutils
BuildRequires:  gcc-c++
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/Constant.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Copy.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  perl(AutoLoader.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(Perlbal.pm)
BuildRequires:  perl(Perlbal/HTTPHeaders.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XSLoader.pm)
# Tests:
BuildRequires:  perl(Test/More.pm)


Source44: import.info

%description
This module is used to read HTTP headers from a string and to parse them
into an internal storage format for easy access and modification. You can
also ask the module to reconstitute the headers into one big string, useful
if you're writing a proxy and need to read and write headers while
maintaining the ability to modify individual parts of the whole.

%prep
%setup -q -n %{libname}-%{version}
# Work around bug in EU::MM (RT#68613), remove forced CC options
sed -i -e "/CCFLAGS/d" Makefile.PL

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 OPTIMIZE="%{optflags}"
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name '*.bs' -empty -delete
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendor_archlib}/auto/Perlbal/XS
%{perl_vendor_archlib}/Perlbal/XS

%changelog
