# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Class/Inspector.pm) perl(ExtUtils/MakeMaker.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Pod-Weaver-Section-Consumes
%define upstream_version 0.010

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_9

Summary:    Add a list of roles to your POD
License:    GPLv1+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Pod/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Module/Load.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Pod/Elemental/Element/Nested.pm)
BuildRequires: perl(Pod/Elemental/Element/Pod5/Command.pm)
BuildRequires: perl(Pod/Weaver/Role/Section.pm)
BuildRequires: perl(aliased.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch: noarch
Source44: import.info

%description
This the Pod::Weaver manpage section plugin creates a "CONSUMES" section in
your POD which will contain a list of all the roles consumed by your class.
It accomplishes this by attempting to compile your class and interrogating
its metaclass object.

Classes which do not have a 'meta' method will be skipped.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc README LICENSE META.yml META.json
%perl_vendor_privlib/*




%changelog
