%define module_version 0.04
%define module_name Process-MaxSize
# BEGIN SourceDeps(oneline):
BuildRequires: /proc perl(ExtUtils/MakeMaker.pm) perl(Log/Log4perl.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Restart processes when they exceed a size limit
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MS/MSCHILLI/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`Process::MaxSize' helps to contain perl programs that leak memory.
It defines a watchdog that, at well defined locations within a program,
checks the current process size and triggers a restart routine in case
a predefined size limit is exceeded.

To define a new watchdog, use the `Process::MaxSize' constructor:

    my $watchdog = Process::MaxSize->new();

By default, the memory watchdog will be set to 10M of memory and
a restart function that `exec's the same process again with a copy
of all command line arguments. To use different settings, let the
constructor know:

    my @argv = @ARGV;

      # Limit the process to 100 MB
    my $watchdog = Process::MaxSize->new(
        max_size => "100m",
        restart  => sub { exec($0, @argv) or 
                            die "Can't restart!" },
    );

`max_size' specifies the maximum real memory consumption allowed in KBytes, 
unless the letter `"m"' indicates that you mean MBytes.

`restart' is a code ref that performs an arbitrary action. By default,
the current program gets restarted via `exec' and a copy of its
command line arguments @ARGV. `Process::MaxSize' is going to
change to the original start directory (of the time the constructor
was called) before calling the restart routine.

The check method checks the current memory consumption and triggers
the `restart' routine if the limit is exceeded:

        $watchdog->check();

You want to plant the call to the `check()' method at a location

=over 4

=item *

where the program whizzes by periodically to make sure you check as soon
as the process exceeds the memory limit and

=item *

where the program can be safely terminated and restarted.

=back

By default, `Process::MaxSize' will sleep 2 seconds before restarting
the process. This is to prevent that it will hog the CPU if something
goes wrong with the exec and the process ends up in an infinite loop.
To eliminate this precautious setting, set the `sleep' parameter
to the required number of seconds in the constructor call:

    my $watchdog = Process::MaxSize->new(
        sleep    => 0,
    );

The `restart' method doesn't need to restart the program. It can
be used to simply set a flag which indicates another part of the program
that the preset size limit has been exceeded:

    my $watchdog = Process::MaxSize->new(
        restart  => sub { $out_of_memory = 1 },
    );

This can come in handy when the program flow requires that the program
needs to terminate/restart at a different point in the flow than the 
location where it detects that the process exceeds the memory limits.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%changelog
