Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Wordlist.pm) perl(Term/ReadKey.pm) perl(Test/CPAN/Meta.pm) perl(Test/EOL.pm) perl(Test/NoBreakpoints.pm) perl(Test/NoTabs.pm) perl(Test/PAUSE/Permissions.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Portability/Files.pm) perl(Test/Spelling.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       perl-RT-Client-REST 
Version:    0.72
Release:    alt1_4
License:    GPL-1.0-or-later OR Artistic-1.0-Perl
Summary:    Talk to RT using REST protocol 
Url:        https://metacpan.org/release/RT-Client-REST
Source:     https://cpan.metacpan.org/authors/id/D/DJ/DJZORT/RT-Client-REST-%{version}.tar.gz
BuildArch:  noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(DateTime.pm)
BuildRequires:  perl(DateTime/Format/DateParse.pm)
BuildRequires:  perl(Exception/Class.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(HTTP/Cookies.pm)
BuildRequires:  perl(HTTP/Request/Common.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(Params/Validate.pm)
BuildRequires:  perl(parent.pm)
BuildRequires:  perl(Try/Tiny.pm)
BuildRequires:  perl(vars.pm)
# Tests
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(HTTP/Response.pm)
BuildRequires:  perl(HTTP/Server/Simple.pm)
BuildRequires:  perl(HTTP/Server/Simple/CGI.pm)
BuildRequires:  perl(IO/File.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(IO/Pipe.pm)
BuildRequires:  perl(IO/Socket.pm)
BuildRequires:  perl(IPC/Open3.pm)
BuildRequires:  perl(Socket.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests:
# CPAN::Meta not helpful
# CPAN::Meta::Prereqs not helpful

# Remove underspecified dependencies

Source44: import.info
%filter_from_requires /^perl(HTTP.Server.Simple.pm)/d

%description
RT::Client::REST is a set of object-oriented Perl modules designed to make
communicating with RT using REST protocol easy. Most of the features have been
implemented and tested with rt 3.6.0 and later.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(blib.pm)
Requires:       perl(HTTP/Server/Simple.pm) >= 0.440

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n RT-Client-REST-%{version}
# Delete author and release tests
rm t/{author,release}-* t/60-with-rt.t
perl -i -ne 'print $_ unless m{^t/(?:author|release)-.*}' MANIFEST
perl -i -ne 'print $_ unless m{^t/60-with-rt\.t}' MANIFEST
# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
unset AUTHOR_TESTING RELEASE_TESTING
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
unset AUTHOR_TESTING RELEASE_TESTING
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc --no-dereference LICENSE
%doc CHANGES CONTRIBUTORS examples README TODO
%{perl_vendor_privlib}/*

%files tests
%{_libexecdir}/%{name}

%changelog
