%define module_name Retry
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moo.pm) perl(MooX/Types/MooseLike/Base.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.04
Release: alt1
Summary: feature module, this provides a method to wrap any function in automatic
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TJ/TJC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A one-feature module, this provides a method to wrap any function in automatic
retry logic, with exponential back-off delays, and a callback for each time an
attempt fails.

Example:

  my $agent = Retry->new(
    failure_callback => sub { warn "oh dear, error: " . $_[0]; },
  );
  eval {
    $agent->retry(
      sub {
        this_code_might_die();
      }
    );
  };
  if ($@) {
    die "We totally failed!";
    # Note that if we succeeded on a retry, this won't get called.
  }


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/R*

%changelog
