Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Class/Data/Inheritable.pm) perl(Class/ISA.pm) perl(Class/Inspector.pm) perl(Data/Printer.pm) perl(File/Slurp.pm) perl(File/Slurper.pm) perl(Module/Info.pm) perl(Module/Load.pm) perl(PPI.pm) perl(Path/Class.pm) perl(Pod/Usage.pm) perl(Test/Class.pm) perl(Test/Class/Most.pm) perl(Test/MockObject/Extends.pm) perl(Test/Most.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-SNMP-Info
%global cpan_version 3.970001
Version:        3.970.1
Release:        alt1_1
Summary:        Object Oriented Perl5 Interface to Network devices and MIBs through SNMP
License:        BSD-3-Clause
URL:            https://metacpan.org/release/SNMP-Info
Source0:        https://cpan.metacpan.org/authors/id/O/OL/OLIVER/SNMP-Info-%{cpan_version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  glibc-core glibc-timezones glibc-utils iconv
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
# Class::ISA not used at tests
# constant not used at tests
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(Math/BigInt.pm)
# Module::Info not used at tests
# Module::Load not used at tests
# mro not used at tests
BuildRequires:  perl(NetAddr/IP.pm)
BuildRequires:  perl(NetAddr/IP/Lite.pm)
# PPI not used at tests
BuildRequires:  perl(Regexp/Common.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(SNMP.pm)
BuildRequires:  perl(Socket.pm)
# Tests:
BuildRequires:  perl(Test/More.pm)
# Optional tests:
# File::Find not used
# Test::Distribution not used

Requires:       perl(mro.pm)
Requires:       perl(NetAddr/IP.pm) >= 4.068
Source44: import.info

%description
SNMP::Info gives an object oriented interface to information obtained
through SNMP.

%prep
%setup -q -n SNMP-Info-%{cpan_version}
find contrib -type f | xargs chmod -x 

%build
perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes contrib README
%{perl_vendor_privlib}/SNMP*

%changelog
