# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dump.pm) perl(Digest/MD5.pm) perl(File/ShareDir.pm) perl(FindBin.pm) perl(HTTP/Date.pm) perl(HTTP/Parser/XS.pm) perl(HTTP/Status.pm) perl(IO/Socket.pm) perl(IO/Socket/INET.pm) perl(LWP/UserAgent.pm) perl(Module/Build/Tiny.pm) perl(Net/Server.pm) perl(Net/Server/SS/PreFork.pm) perl(Plack.pm) perl(Socket.pm) perl(Symbol.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Requires.pm) perl(Test/TCP.pm) perl(Try/Tiny.pm) perl(base.pm) perl(parent.pm) perl(subs.pm)
# END SourceDeps(oneline)
%define module_name Starwoman
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: because Starman does the same thing over and over again expecting different results
Group: Development/Perl
License: perl
URL: https://github.com/rabcyr/Starwoman

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AS/ASHLEYW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Starwoman is a PSGI perl web server that has unique features such as:

=over 4

=item High Performance

Uses the fast XS/C HTTP header parser

=item Preforking

Spawns workers preforked like most high performance UNIX servers
do. Starwoman also reaps dead children and automatically restarts the
worker pool.

=item Signals

Supports `HUP' for graceful worker restarts, and `TTIN'/`TTOU' to
dynamically increase or decrease the number of worker processes, as
well as `QUIT' to gracefully shutdown the worker processes.

=item Superdaemon aware

Supports the Server::Starter manpage for hot deploy and graceful restarts.

=item Multiple interfaces and UNIX Domain Socket support

Able to listen on multiple interfaces including UNIX sockets.

=item Small memory footprint

Preloading the applications with `--preload-app' command line option
enables copy-on-write friendly memory management. Also, the minimum
memory usage Starwoman requires for the master process is 7MB and
children (workers) is less than 3.0MB.

=item PSGI compatible

Can run any PSGI applications and frameworks

=item HTTP/1.1 support

Supports chunked requests and responses, keep-alive and pipeline requests.

=item UNIX only

This server does not support Win32.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/S*
%perl_vendor_privlib/P*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
