# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Math/Cephes.pm) perl(Module/Build.pm) perl(Scalar/Util.pm) perl(Statistics/Data.pm) perl(Statistics/Lite.pm) perl(String/Util.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.10
%define module_name Statistics-Zed
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: Data-handling and calculations for ratio of observed to standard deviation (zscore)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RG/RGARTON/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Methods are provided to:

+ calculate a z-score: ratio of an observed deviation to a standard deviation, with optional continuity correction

+ convert z-value to normal p-value, and convert p-value to normal-equiv z-value

+ load, add, save & retrieve observed, expected and variance values to compute z_score across samples

+ support z-testing in Statistics::Sequences and other modules.

Optionally, load/add observed, expected and variance values (named as such) and compute a z-score between/after updates. The module uses Statistics::Data to cache each observed, expected and variance values, and to provide for the load/add methods, as well as to save/retrieve these values between class calls (not documented here, see Statistics::Data). Alternatively, simply call zscore and pvalue, passing them the values by these labels in a hash (or hashref), with either single numerical values or referenced arrays of the same. Optionally, specify tails, where relevant, and precision the returned z-values and p-values as required.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
