%define module_name String-TagString
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: parse and emit tag strings (including tags with values)
Group: Development/Perl
License: perl
URL: https://github.com/rjbs/String-TagString

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RJ/RJBS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
String::TagString enables Web 2.0 synergy by deconstructing and synthesizing
folksonomic nomenclature into structured dynamic programming ontologies.

Also, it parses strings of "tags" into hashrefs, so you can tag whatever junk
you want with strings.

A set of tags is an unordered set of simple strings, each possibly associated
with a simple string value.  This library parses strings of these tags into
hashrefs, and turns hashrefs (or arrayrefs) back into these strings.

This string:

  my $string = q{ beef cheese: peppers:hot };

Turns into this hashref:

  my $tags = {
    beef    => undef,
    cheese  => '',
    peppers => 'hot',
  };

That hashref, of course, would turn back into the same string -- although
sorting is not guaranteed.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/S*

%changelog
