# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Scalar/Util.pm) perl(Sub/Util.pm) perl(attributes.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Sub-Talisman
%define upstream_version 0.006

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Use attributes to tag or classify subs
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Sub/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Attribute/Handlers.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Scalar/Does.pm)
BuildRequires: perl(Sub/Identify.pm)
BuildRequires: perl(Sub/Name.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(namespace/clean.pm)
BuildArch:  noarch
Source44: import.info

%description
Sub::Talisman allows you to define "talisman" attributes for your subs, and
provides a basic introspection API for these talismans.

Class Methods
    Sub::Talisman's methods are designed to be called as class methods.

    * 'setup_for $package, \%%options'

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc COPYRIGHT Changes LICENSE META.yml  README SIGNATURE
%{perl_vendor_privlib}/*


%changelog
