%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(warnings/register.pm)
# END SourceDeps(oneline)
%define module_version 1.0.5
%define module_name Switch-Perlish
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.5
Release: alt1
Summary: A Perlish implementation of the `switch' statement.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BR/BROQ/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is a Perl-oriented implementation of the `switch' statement. It uses
smart-matching in `case's which can be configured and extended by the user.
There is no magical syntax so `switch'/`case'/`default' expect coderefs,
which are most simply provided by anonymous subroutines. By default successful
`case' statements do not fall through[1]. To fall through a `case' block
call the `fallthrough' subroutine explicitly. For `C' style `switch'
behaviour[2] simply call the module with an upper-case *C* i.e

  use Switch::Perlish 'C';

*[1] To 'fall through' in a `case' block means that the `switch' block
isn't exited upon success.*

*[2] upon a `case' succesfully matching all subsequent `case's succeed; to
break out from the current `switch' completely use `stop'.*


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
