%define module_name Telegram-Bot
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IO/Socket/SSL.pm) perl(Log/Any.pm) perl(Mojolicious.pm) perl(Test/Exception.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.027
Release: alt1
Summary: A base class to make your very own Telegram bot
Group: Development/Perl
License: perl
URL: https://github.com/jkg/Telegram-Bot

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JK/JKG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
NOTE: This API should not yet be considered stable.

Creating a bot is easy:

    package MyBot;
    
    use Mojo::Base 'Telegram::Bot::Brain';

    has token => 'YOURTOKENHERE';

    # is this a message we'd like to respond to?
    sub _hello_for_me {
      my ($self, $msg) = @_;
      # look for the word 'hello' with or without a leading slash
      if ($msg->text =~ m{/?hello}i) {
        return 1;
      }
      return 0;
    }

    # send a polite reply, to either a group or a single user,
    # depending on where we were addressed from
    sub _be_polite {
      my ($self, $msg) = @_;

      # is this a 1-on-1 ?
      if ($msg->chat->is_user) {
        $self->send_message_to_chat_id($msg->chat->id, "hello there");
      }
      # group chat
      else {
        $self->send_message_to_chat_id($msg->chat->id, "hello to everyone!");
      }
    }

    # setup our bot
    sub init {
      my $self = shift;
      $self->add_listener(\&_hello_for_me,  # criteria
                          \&_be_polite      # response
                         ); 
 
    }

    1;

Now just:

    perl -MMyBot -E 'MyBot->new->think'

and you've got yourself a stew, baby! Or a bot, anyway.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes TODO.md
%perl_vendor_privlib/T*

%changelog
