%define module_name Test-OpenTracing-Integration
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bytes/Random/Secure.pm) perl(Carp.pm) perl(Data/Perl/Role/Collection/Hash.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/MakeMaker/CPANfile.pm) perl(HTTP/Headers.pm) perl(List/Util.pm) perl(Moo.pm) perl(OpenTracing/GlobalTracer.pm) perl(OpenTracing/Implementation/Interface/Bootstrap.pm) perl(OpenTracing/Implementation/Test.pm) perl(OpenTracing/Role.pm) perl(PerlX/Maybe.pm) perl(Scalar/Util.pm) perl(Test/Builder.pm) perl(Test/Deep.pm) perl(Test/Most.pm) perl(Test/OpenTracing/Interface.pm) perl(Test/Time/HiRes.pm) perl(Tree.pm) perl(Types/Standard.pm) perl(aliased.pm) perl(namespace/clean.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.104.1
Release: alt1
Summary: Easy Testing of OpenTracing Integrations
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VA/VANHOESEL/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Your 'App'

    package MyApp {
        use OpenTracing::GlobalTracer qw/$TRACER/;
        
        sub something {
            my $scope = $TRACER->start_active_span('some-work');
            
            $TRACER->start_span('more-work')->finish;
            
            $scope->close
        }
    }

In the test:

    use OpenTracing::Implementation qw/Test/;
    use Test::OpenTracing::Integration;
    
    use MyApp;
    
    MyApp->something();
    
    global_tracer_cmp_easy(
        [
            { operation_name => 'more-work', level => 1 },
        ],
        'child span created'
    );

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE.md CHANGES README.md
%perl_vendor_privlib/T*
%perl_vendor_privlib/O*

%changelog
