%define module_name Test-TCM-Role-API
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(HTTP/Message.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Plack/Test.pm) perl(Socket.pm) perl(Test/Deep.pm) perl(Test/Differences.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Role to test PSGI-based JSON API using L<Test::Class::Moose>.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CH/CHESNOKOV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
package TestsFor::MyApp::Controller::API::v1::Some::Thing

    use Test::Class::Moose;
    with qw(
        Test::TCM::Role::API
    );

    sub _api_route_prefix { '/api/v1' }

    sub test_some_route ($test, $) {

        # Calls "GET /api/v1/character"
        $test->api_ok(
            'List characters',
            [GET => '/character'],
            {
                status       => HTTP_OK,
                json_content => {
                    superhashof(
                        {
                            attributes =>
                              { map { $_ => ignore() } qw(id name created) },
                        }
                    )
                },
            }
        );

        $test->api_ok(
            'Create character',
            [
                POST => '/character' => {
                    name    => 'Player 1',
                    user_id => 12345,
                }
            ],
            {
                status       => HTTP_OK,
                json_content => { success => 1 },
            }
        );
    }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/T*

%changelog
