%define module_name Text-Balanced-Marpa
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Const/Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Marpa/R2.pm) perl(Moo.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Tree.pm) perl(Try/Tiny.pm) perl(Types/Standard.pm) perl(open.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.08
Release: alt1
Summary: Extract delimited text sequences from strings
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RS/RSAVAGE/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
the Text::Balanced::Marpa manpage provides a the Marpa::R2 manpage-based parser for extracting delimited text
sequences from strings. The text outside and inside the delimiters, and delimiters themselves, are
all stored as nodes in a tree managed by the Tree manpage.

Nested strings, with the same or different delimiters, are stored as daughters of the nodes which
hold the delimiters.

This module is a companion to the Text::Delimited::Marpa manpage. The differences are discussed in the the FAQ entry elsewhere in this document
below.

See the the FAQ entry elsewhere in this document for various topics, including:

=over 4

=item o UFT8 handling

See t/utf8.t.

=item o Escaping delimiters within the text

See t/escapes.t.

=item o Options to make nested and/or overlapped delimiters fatal errors

See t/colons.t.

=item o Using delimiters which are part of another delimiter

See t/escapes.t and t/perl.delimiters.

=item o Processing the tree-structured output

See scripts/traverse.pl.

=item o Emulating the Text::Xslate manpage's use of '<:' and ':>

See t/colons.t and t/percents.t.

=item o Implementing a really trivial HTML parser

See t/html.t.

In the same vein, see t/angle.brackets.t, for code where the delimiters are just '<' and '>'.

=item o Handling multiple sets of delimiters

See t/multiple.delimiters.t.

=item o Skipping (leading) characters in the input string

See t/skip.prefix.t.

=item o Implementing hard-to-read text strings as delimiters

See t/silly.delimiters.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes Changelog.ini examples
%perl_vendor_privlib/T*

%changelog
