# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Text-Greeking
%define upstream_version 0.15

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    A module for generating meaningless text
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Text/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
Greeking is the use of random letters or marks to show the overall
appearance of a printed page without showing the actual text. Greeking is
used to make it easy to judge the overall appearance of a document without
being distracted by the meaning of the text.

This is a module is for quickly generating varying meaningless text from
any source to create this illusion of the content in systems.

This module was created to quickly give developers simulated content to
fill systems with simulated content. Instead of static Lorem Ipsum text, by
using randomly generated text and optionally varying word sources,
repetitive and monotonous patterns that do not represent real system usage
is avoided.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
