# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Text-Matrix
%define upstream_version 1.00

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_11

Summary:    Text table layout for matrices of short regular data
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Text/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(List/MoreUtils.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Storable.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Module/Build.pm)
BuildArch: noarch
Source44: import.info

%description
Text::Matrix is a specialist table display module for display
of matrices of single-character (such as Y/N for yes/no) or short
multi-character data against row and column labels that are sufficiently
longer that conventional table layouts distort the layout of the data.

The core aim is to base the layout on the tabular data concisely and
formatted regularly to reflect the terseness of the underlying data, without
being forced to compensate for the longer length of the labels for the
columns and rows.

Text::Matrix will also optionally split the matrix into several
sections based on width of the generated matrix, suitable for display in
situations where you don't want external line-wrapping to confuse the
layout. (Display on an xterm, cut-n-paste into an email, etc.)

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL installdirs=vendor

./Build

%check
./Build test

%install
./Build install destdir=%{buildroot}

%files
%doc META.yml README SIGNATURE Changes
%perl_vendor_privlib/*




%changelog
