# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Class/Accessor/Complex.pm) perl(Class/Accessor/Constructor.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/Command.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Sub/Name.pm) perl(Test/Builder/Module.pm) perl(UNIVERSAL/require.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.10
%define module_name Text-Pipe
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: Common text filter API
Group: Development/Perl
License: perl
URL: http://search.cpan.org/dist/Text-Pipe/

Source0: http://cpan.org.ua/authors/id/M/MA/MARCEL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This class is a factory for text pipes. A pipe has a `filter()' method
through which input can pass. The input can be a string or a reference to an
array of strings. Pipes can be stacked together using
the Text::Pipe::Stackable manpage.

The problem that this distribution tries to solve is that there are several
distributions on CPAN which use text filtering in some way or other, for
example the Template Toolkit or Web::Scraper. But each distribution is
somewhat different, and they have to reimplement the same text filters over
and over again.

This distribution aims at offering a common text filter API. So if you want to
use text pipes with Template Toolkit, you just need to write an adapter. With
Web::Scraper, you can even use text pipes directly Using the `PIPE()'
function, as shown in the synopsis.

Text pipe segments live in the `Text::Pipe::' namespace. So if you implement
a `Text::Pipe::Foo::Bar' pipe segment, you can instantiate it with

    my $pipe = Text::Pipe->new('Foo::Bar');

Some pipe segments take arguments. These are described in their respective
class documentations.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.mkdn Changes LICENSE README
%perl_vendor_privlib/T*

%changelog
