Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Perform optional tests
%bcond_with perl_Tk_DirSelect_enables_optional_test

Name:           perl-Tk-DirSelect
Version:        1.12
Release:        alt2_41
Summary:        Cross-platform directory selection widget
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Tk-DirSelect
Source0:        https://cpan.metacpan.org/authors/id/M/MJ/MJCARMAN/Tk-DirSelect-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  perl
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Tk.pm)
BuildRequires:  perl(Tk/BrowseEntry.pm)
BuildRequires:  perl(Tk/Button.pm)
BuildRequires:  perl(Tk/DirTree.pm)
BuildRequires:  perl(Tk/Frame.pm)
BuildRequires:  perl(Tk/Label.pm)
BuildRequires:  perl(Tk/Toplevel.pm)
BuildRequires:  perl(vars.pm)
# Win32API::File not used
# Tests:
BuildRequires:  perl(Test/More.pm) 
BuildRequires:  perl(warnings.pm)
%if %{with perl_Tk_DirSelect_enables_optional_test}
# Optional tests:
BuildRequires:  perl(Pod/Coverage.pm)
# Test::CheckManifest not used
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
%endif
Requires:       perl
Source44: import.info

%description
This module provides a cross-platform directory selection widget. For
systems running Microsoft Windows, this includes selection of local and
mapped network drives. A context menu (right-click or <Button3>) allows the
creation, renaming, and deletion of directories while browsing.

%prep
%setup -q -n Tk-DirSelect-%{version}
sed -i 's/\r//' README Changes
%if !%{with perl_Tk_DirSelect_enables_optional_test}
rm t/pod*
perl -i -ne 'print $_ unless m{^t/pod}' MANIFEST
%endif

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install

make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} $RPM_BUILD_ROOT/*

#sed -i 's/\r//' README Changes

%check
unset RELEASE_TESTING
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
