# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Regexp/Grammars.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Translate-Fluent
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.6.2
Release: alt1
Summary: A perl implementation of Project Fluent Translations.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NEVES/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Project Fluent (https://projectfluent.org/) is a research project by
Mozilla, aiming at more natural sounding translations. I stumbled upon it
while looking for a alternative to gettext, which I think have served
software quite well for a long time, but is not enough for our time.

Multiple things attracted me to Fluent, but the ability to use different
variables to change the final sentence was the most important one. Look
at this example from their website, as an example:

  shared-photos =
    {$userName} {$photoCount ->
        [one] added a new photo
       *[other] added {$photoCount} new photos
    } to {$userGender ->
        [male] his stream
        [female] her stream
       *[other] their stream
    }.

This example, with the variables:

  { userName    => "Anne",
    useGender   => "female",
    photoCount  => 3,
  }

will result in the sentence:

  Anne added 3 new photos to her stream

It uses two different variables, one of which is not even shown in the final
text directly, to define the text.

This is impossible to do with gettext.

And that's why Translate::Fluent was started.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/T*

%changelog
