# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN/Meta.pm) perl(Pod/Readme/Brief.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    UDCode
%define upstream_version 1.04

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Does a set of code words form a uniquely decodable code?
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module//%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
A code is a set of strings, called the _code words_. A code is "uniquely
decodable" if any string _S_ that is a concatenation of code words is so in
_exactly one way_.

For example, the code '"ab", "abba", "b"' is _not_ uniquely decodable,
because '"abba" . "b" eq "ab" . "b" . "ab"'. But the code '"a", "ab",
"abb"' _is_ uniquely decodable, because there is no such pair of sequences
of code words.

'is_udcode'
    'is_udcode(@words)' returns true if and only if the specified code is
    uniquely decodable.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%{make}

%check
%{make} test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  README
%perl_vendor_privlib/*

%changelog
