# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(XML/Parser.pm) perl(XML/SAX.pm) perl(XML/SAX/Expat.pm) perl(XML/SAX/PurePerl/DebugHandler.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name XML-SAX-Expat-Incremental
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Incremental/non-blocking SAX Driver for Expat
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/N/NU/NUFFIN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Most XML parsers give a callback interface within an encapsulated loop. That
is, you call

_$p->parse_whatever($whatever);

And eventually, when `$whatever' is depleted by the parser, `$p->parse'
will return.

Sometimes you don't want the parser to control the loop for you. For example,
if you need to retrieve your XML in chunks in a funny way, you might need to do
something like

_my $doc = '';
_while (defined(my $buffer = get_more_xml())) {
__$doc .= $buffer;
_}

_$p->parse_string($doc);

which is not very convenient, or efficient. You could use the perltie manpage to tie a
filehandle which does this for you, but that only works some of the time (for
example, say you have two inputs coming in simultaneously).

XML::Parser::ExpatNB
solves this by providing three methods:

=over 4

=item parse_start

=item parse_more

=item parse_done

=back

This interface lets you move the loop to outside the parser, retaining control.

The callbacks are executed in the same manner, just that now, when there is no
left to parse, instead of taking more data from a source on it's own, the
parser returns control to you.

_$p->parse_start; # you can omit this - parse_start will
_                 # be called automatically as needed

_while(defined(my $buffer = get_more_xml())) {
__$p->parse_more($buffer);
_}

_$p->parse_done;

This module is a subclass of the XML::SAX::Expat manpage which is to
the XML::Parser::ExpatXS manpage as the XML::SAX::Expat manpage is to the XML::Parser manpage itself.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/X*

%changelog
