# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    relative
%define upstream_version 0.04

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_15

Summary:    Load modules with relative names
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module//%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Test/More.pm)
BuildRequires: perl(UNIVERSAL/require.pm)

BuildArch: noarch


Provides: perl(relative.pm)
Source44: import.info

%description
This module allows you to load modules using only parts of their name,
relatively to the current module or to a given module. Module names are by
default searched below the current module, but can be searched upper in the
hierarchy using the '..::' syntax.

In order to further loosen the namespace coupling, 'import' returns the
full names of the loaded modules, making object-oriented code easier to
write.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes README META.yml
%perl_vendor_privlib/*




%changelog
