%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(ExtUtils/MakeMaker.pm) perl(Symbol/Values.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(Tie/Handle.pm) perl(Tie/Hash.pm) perl(Tie/Scalar.pm) perl(base.pm) perl(warnings/register.pm)
# END SourceDeps(oneline)
%define module_version 1.04
%define module_name warnings-DynamicScope
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.04
Release: alt1
Summary: Provides warning categories in dynamic scope.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/K/KM/KMIYAZAKI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides warning categories in dynamic scope
through the special variable "%%^W".

=over 4

=item VARIABLE

This modules brings a new special variable called "%%^W".
Yes, it is very similar to special variable "$^W"
in appearance, but these are different things.

But you can use it like special variable "$^W":

 require warnings::DynamicScope;

 package MyPkg;
 use warnings::register;
 
 sub my_func {
     if ($^W{MyPkg}) {
         print "Don't do it!!\n";
     } else {
         print "That's fine\n";
     }
 }
 
 package main;
 $^W = 1;

 {
     local $^W{MyPkg} = 0;
     MyPkg::my_func();
 }
 MyPkg::my_func();

This code prints:

 That's fine.
 Don't do it!!

That's all.

=item DEAD BIT

Each warning category has extra property called "Dead Bit".

The Dead Bit will be set if the string "FATAL" is passed
to the variable "%%^W" as it's value for a key, and then 2
will be returned as the value for a key.

You can use it as blow:

 require warnings::DynamicScope;
 
 package MyPkg;
 use warnings::register;
 use Carp qw(carp croak);
 
 sub func1 {
     if ($^W{MyPkg} == 2) {
        # Dead Bits is on.
         croak("Fatal Error!\n");
 
     } elsif ($^W{MyPkg}) {
         carp("Non Fatal Error!\n");
     }
 }
 
 package main;
 
 $^W{MyPkg} = 'FATAL';    # Set Dead Bit.
 eval { MyPkg::func1() };
 print $@;                # => Fatal Error!
 
 $^W{MyPkg} = 1;          # Set warning bit of category "MyPkg".
 MyPkg::func1();          # => Non Fatal Error!
 
 $^W{MyPkg} = 0;          # Clear all of the bits.
 MyPkg::func1();          # <nothing happens>

=item BEGIN BLOCK

If the variable "%%^W" was used in "BEGIN" block,
it behaves as compiler directive.

So, if you write like:

 BEGIN {
   $^W{uninitialized} = 0;
 }

it brings same result of:

 no warnings 'uninitialized';

=over 4

=item NOTE

All of categories predefined in Perl does not
understand warning bits in dynamic scope, so they
won't work unless it was set by warnings pragma.

=back

=item $^W AND %%^W

The values of variables $^W and %%^W are linked internally
by the keyword 'all':

 $^W = 1;       # is equal to $^W{all} = 1;
 $^W = 0;       # is equal to $^W{all} = 0;
 
 $^W{all} = 1;  # is equal to $^W = 1;
 $^W{all} = 0;  # is equal to $^W = 0;

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/w*

%changelog
