BuildRequires: libdbus-glib-devel
Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate /usr/bin/protoc-c pkgconfig(dbus-1) pkgconfig(xdamage) rpm-build-python3
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global pidginver 2.13.0
%if 0%{?rhel} == 7
# Building 2.14.0 with the V/V bits on EPEL7 is non-trivial. IM only for now.
%global pidginver 2.10.11
%endif

%bcond_without evolution # with

Name:           pidgin-chime
Summary:        Pidgin/libpurple protocol plugin for Amazon Chime
Version:        1.4.1
Release:        alt4_9

License:        LGPLv2
URL:            https://github.com/awslabs/%{name}
Source0:        ftp://ftp.infradead.org/pub/%{name}/%{name}-%{version}.tar.gz

BuildRequires:  pkgconfig(pidgin) >= %{pidginver}
BuildRequires:  pkgconfig(purple) >= %{pidginver}
BuildRequires:  pkgconfig(gnutls) >= 3.2.0
BuildRequires:  pkgconfig(farstream-0.2)
BuildRequires:  pkgconfig(gstreamer-1.0)
BuildRequires:  pkgconfig(gstreamer-app-1.0)
BuildRequires:  pkgconfig(gstreamer-rtp-1.0)
BuildRequires:  pkgconfig(gstreamer-base-1.0)
BuildRequires:  pkgconfig(gstreamer-video-1.0)
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(xcb)
BuildRequires:  pkgconfig(xext)
BuildRequires:  pkgconfig(xfixes)
BuildRequires:  pkgconfig(opus)
BuildRequires:  pkgconfig(libprotobuf-c)
BuildRequires:  pkgconfig(json-glib-1.0)
BuildRequires:  pkgconfig(libxml-2.0)
BuildRequires:  pkgconfig(libsoup-2.4) >= 2.50
BuildRequires:  pkgconfig(libmarkdown)
BuildRequires:  ImageMagick-tools
%if %{with evolution}
BuildRequires:  pkgconfig(evolution-calendar-3.0)
BuildRequires:  pkgconfig(evolution-shell-3.0)
BuildRequires:  pkgconfig(evolution-data-server-1.2)
BuildRequires:  pkgconfig(libebook-1.2)
# libecal changed from -1.2 to -2.0 in e-d-s 3.33.2
# Any conditional BR would be based on %_fedora and be distro-specific
# anyway, so we might as well just not BR it at all, depending on the
# equally distro-specific knowledge that it's in e-d-s-devel with the
# rest.
#BuildRequires:  pkgconfig(libecal-1.2)
#BuildRequires:  pkgconfig(camel-1.2)
%endif
BuildRequires:  gcc
BuildRequires:  gettext-tools
BuildRequires:  libtool
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  desktop-file-utils

Requires:       purple-chime = %{version}-%{release}
Requires:       evolution-chime
Requires:       pidgin >= %{pidginver}
Source44: import.info

%description
A plugin for the Pidgin multi-protocol instant messenger, to support Amazon
Chime.

This package provides the icon set for Pidgin, and a UI plugin to indicate
seen messages.

%package -n purple-chime
Group: Other
Summary:  Libpurple protocol plugin for Amazon Chime

%description -n purple-chime
A plugin for the Pidgin multi-protocol instant messenger, to support Amazon
Chime.

This package provides the Amazon Chime protocol support for the libpurple
messaging library, which is used by Pidgin and other tools.


%if %{with evolution}
%package -n evolution-chime
Group: Other
Summary:  Evolution plugin for Amazon Chime
Requires: pidgin-chime = %{version}-%{release}

%description -n evolution-chime
A plugin for Evolution that allows you to create meetings in Amazon Chime.
%endif

%prep
%setup -q

%build
%configure \
%if %{without evolution}
  --without-evolution \
%endif
  --with-certsdir=%{_sysconfdir}/pki/purple-chime/cacerts;
%make_build

%install
%makeinstall_std
desktop-file-validate %{buildroot}/%{_datadir}/applications/chime-auth.desktop
find %{buildroot} -type f -name "*.la" -delete -print
%find_lang %{name}

%check
make %{?_smp_mflags} check

%files
%{_datadir}/pixmaps/pidgin/protocols/*/chime*
%{_libdir}/pidgin/chimeseen.so
%{_bindir}/chime-joinable.py
%{_bindir}/chime-auth.py
%{_datadir}/applications/*.desktop

%files -n purple-chime -f %{name}.lang
%{_libdir}/purple-2/libchimeprpl.so
%{_libdir}/farstream-0.2/libapp-transmitter.so
%{_libdir}/gstreamer-1.0/libgst*.so
%dir %{_sysconfdir}/pki/purple-chime
%dir %{_sysconfdir}/pki/purple-chime/cacerts
%{_sysconfdir}/pki/purple-chime/cacerts/*.pem

%doc --no-dereference LICENSE
%doc README.md TODO

%if %{with evolution}
%files -n evolution-chime
%{_libdir}/evolution/modules/module-event-from-template.so
%endif

%changelog
