Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Disable tests by default because they fail to run inside mock builds
# at the moment, but can run locally.  To build and run tests, do:
#     rpmbuild -ba --with runtests pykickstart.spec
%bcond_with runtests

Name:      pykickstart
Version:   3.44
Release:   alt1_1
License:   GPL-2.0-only AND MIT
Summary:   Python utilities for manipulating kickstart files.
Url:       http://fedoraproject.org/wiki/pykickstart
# This is a Red Hat maintained package which is specific to
# our distribution.  Thus the source is only available from
# within this srpm.
Source0:   %{name}-%{version}.tar.gz
Source1:   %{name}-%{version}.tar.gz.asc

BuildArch: noarch

BuildRequires: gettext gettext-tools
BuildRequires: python3-devel
BuildRequires: python3-module-requests
BuildRequires: python3-module-pkg_resources python3-module-setuptools

# Only required when building with runtests
%if %{with runtests}
BuildRequires: python3-module-coverage
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink
%endif

Requires: python3-module-kickstart = %{version}-%{release}
Source44: import.info

%description
Python utilities for manipulating kickstart files.

%package -n python3-module-kickstart
Group: System/Libraries
Summary:  Python 3 library for manipulating kickstart files.
Requires: python3-module-requests

%description -n python3-module-kickstart
Python 3 library for manipulating kickstart files.  The binaries are found in
the pykickstart package.

%prep
%setup -q

%build
make PYTHON=%{__python3}

%install
make PYTHON=%{__python3} DESTDIR=%{buildroot} install

%check
%if %{with runtests}
make PYTHON=%{__python3} test
%endif

%files
%doc --no-dereference COPYING
%doc README.rst
%doc data/kickstart.vim
%{_bindir}/ksvalidator
%{_bindir}/ksflatten
%{_bindir}/ksverdiff
%{_bindir}/ksshell
%{_mandir}/man1/ksflatten.1*
%{_mandir}/man1/ksshell.1*
%{_mandir}/man1/ksvalidator.1*
%{_mandir}/man1/ksverdiff.1*

%files -n python3-module-kickstart
%doc docs/2to3
%doc docs/programmers-guide
%doc docs/kickstart-docs.txt
%{python3_sitelibdir_noarch}/pykickstart
%{python3_sitelibdir_noarch}/pykickstart*.egg-info

%changelog
