Group: Networking/WWW
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_without gdbm
%bcond_with sqlite
%bcond_with mysql

Name:           qsf
Version:        1.2.15
Release:        alt1_8
Summary:        Quick Spam Filter

License:        Artistic-2.0
URL:            http://www.ivarch.com/programs/qsf/
Source0:        http://downloads.sourceforge.net/qsf/qsf-%{version}.tar.bz2

BuildRequires:  gcc

%{?with_gdbm:BuildRequires: libgdbm-devel}
%{?with_sqlite:BuildRequires: sqlite2-devel}
%{?with_mysql:BuildRequires: libmariadb-devel}
Source44: import.info

%description
Quick Spam Filter (QSF) is an Open Source email classification filter,
designed to be small, fast, and accurate, which works to classify
incoming email as either spam or non-spam.

To recognise spam, QSF strips the text out of the email (using MIME
decoding and HTML stripping) and then splits it into tokens (words,
word pairs, URLs, and so on). These tokens are then looked up in a
database and analysed using the Bayesian technique to see whether the
email should be classified as spam or not.

QSF is designed to be run by an MDA, such as procmail.

%prep
%setup -q

%build
%configure \
%{!?with_gdbm:    --without-gdbm} \
%{!?with_sqlite:  --without-sqlite} \
%{!?with_mysql:   --without-mysql} \
;
%make_build

%check
make test

%install
%makeinstall_std

%files
%doc --no-dereference doc/COPYING
%doc README doc/NEWS doc/TODO doc/postfix-howto
%{_bindir}/qsf
%{_mandir}/man1/qsf.1*

%changelog
