Group: File tools
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
%define fedora 38
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with tests
%if 0%{?rhel} == 7
%global python3_pkgversion 36                                                                                                                           
%endif

Name:           rpmconf
Summary:        Tool to handle rpmnew and rpmsave files
License:        GPL-3.0-only
Version:        1.1.10
Release:        alt1_2
URL:            https://github.com/xsuchy/rpmconf
# source is created by:
# git clone https://github.com/xsuchy/rpmconf.git
# cd rpmconf; tito build --tgz
Source0:        %{name}-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  docbook-utils
BuildRequires:  docbook-dtd31-sgml
%if 0%{?rhel} > 9 || 0%{?fedora} > 38
BuildRequires:  python3-module-pkg_resources python3-module-setuptools
%endif
BuildRequires:  python3-module-sphinx python3-module-sphinx-sphinx-build-symlink
BuildRequires:  python3-devel
Requires:       %{name}-base
Requires:       python3-module-rpmconf
%if 0%{?rhel} == 7
Requires:       python36-rpm
BuildRequires:  python36-rpm
%else
Requires:       python3-module-rpm
BuildRequires:  python3-module-rpm
%if %{with tests}
BuildRequires:  python3-module-pylint
BuildRequires:  python3-module-six
%endif
%endif
# mergetools
%if 0%{?rhel} == 7
  # nothing
%else
#Requires: diffuse
Requires: diffutils
Requires: kdiff3
Requires: meld
Requires: vim-X11 vimtutor
Requires: vim-common vimtutor
# sdiff
Requires: diffutils
%endif
Source44: import.info

%description
This tool search for .rpmnew, .rpmsave and .rpmorig files and ask you what to do
with them:
Keep current version, place back old version, watch the diff or merge.

%package -n python3-module-rpmconf
Group: File tools
Summary:        Python interface for %{name}
BuildArch:      noarch

%description -n python3-module-rpmconf
Python interface for %{name}. Mostly useful for developers only.

%package -n python3-module-rpmconf-doc
Group: File tools
Summary:        Documentation of python interface for %{name}
BuildArch:      noarch

%description -n python3-module-rpmconf-doc
Documentation generated from code of python3-rpmconf.

%package base
Group: File tools
Summary: Filesystem for %{name}
BuildArch: noarch

%description base
Directory hierarchy for installation scripts, which are handled by rpmconf.

%prep
%setup -q

%build
sed -i 's/__version__ = .*/__version__ = "%{version}"/' rpmconf/rpmconf.py
sed -i 's/version = .*,/version = "%{version}",/' setup.py 
%{__python3} setup.py build
docbook2man rpmconf.sgml
%if 0%{?rhel} == 7
make -C docs html man SPHINXBUILD=sphinx-build-3.6
%else
make -C docs html man
%endif

%install
%{__python3} setup.py install --skip-build \
    --install-scripts %{_sbindir} \
    --root %{buildroot}
install -D -m 644 rpmconf.8 %{buildroot}%{_mandir}/man8/rpmconf.8
install -D -m 644 docs/build/man/rpmconf.3 %{buildroot}%{_mandir}/man3/rpmconf.3
mkdir -p %{buildroot}%{_datadir}/rpmconf/

%check
%if %{with tests}
pylint-3 rpmconf bin/rpmconf || :
%endif

%files
%doc --no-dereference LICENSE
%{_sbindir}/rpmconf
%{_mandir}/man8/rpmconf.8*
%doc README.md

%files -n python3-module-rpmconf
%doc --no-dereference LICENSE
%{python3_sitelibdir_noarch}/rpmconf/
%{python3_sitelibdir_noarch}/rpmconf-*.egg-info
%{_mandir}/man3/rpmconf.3*

%files -n python3-module-rpmconf-doc
%doc --no-dereference LICENSE
%doc docs/build/html/

%files base
%dir %{_datadir}/rpmconf

%changelog
