Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: /usr/bin/valgrind pkgconfig(libunwind-coredump)
# END SourceDeps(oneline)
BuildRequires: gcc-c++
%define fedora 34
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%if 0%{?fedora} || 0%{?rhel} > 7
# Enable python3 build by default
%bcond_without python3
%else
%bcond_with python3
%endif

%if 0%{?suse_version}
  %define libdw_devel libdw-devel
  %define libelf_devel libelf-devel
%else
  %define libdw_devel elfutils-devel
  %define libelf_devel elfutils-libelf-devel
%endif

%define glib_ver 2.43.4

Name: satyr
Version: 0.38
Release: alt4_4
Summary: Tools to create anonymous, machine-friendly problem reports
License: GPLv2+
URL: https://github.com/abrt/satyr
Source0: https://github.com/abrt/%{name}/releases/download/%{version}/%{name}-%{version}.tar.gz
%if %{with python3}
BuildRequires: python3-devel
%endif
BuildRequires: libasm-devel libdw-devel libelf-devel
BuildRequires: libelf-devel
BuildRequires: binutils-devel
BuildRequires: librpm-devel
BuildRequires: libtool
BuildRequires: doxygen
BuildRequires: automake
BuildRequires: gcc-c++
BuildRequires: gdb
BuildRequires: gperf
BuildRequires: libjson-c-devel
BuildRequires: glib2-devel libgio libgio-devel
%if %{with python3}
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink
%endif
Requires: libjson-c5
Requires: libgio >= %{glib_ver}
Source44: import.info

%description
Satyr is a library that can be used to create and process microreports.
Microreports consist of structured data suitable to be analyzed in a fully
automated manner, though they do not necessarily contain sufficient information
to fix the underlying problem. The reports are designed not to contain any
potentially sensitive data to eliminate the need for review before submission.
Included is a tool that can create microreports and perform some basic
operations on them.

%package devel
Group: Development/Other
Summary: Development libraries for %{name}
Requires: %{name} = %{version}-%{release}

%description devel
Development libraries and headers for %{name}.

%if %{with python3}
%package -n python3-module-satyr
Group: Development/Other
%{?python_provide:%python_provide python3-satyr}
Summary: Python 3 bindings for %{name}
Requires: %{name} = %{version}-%{release}

%description -n python3-module-satyr
Python 3 bindings for %{name}.
%endif

%prep
%setup -q

%build
autoreconf

%configure \
%if %{without python3}
        --without-python3 \
%endif
        --disable-static \
        --enable-doxygen-docs

%make_build

%install
%makeinstall_std

# Remove all libtool archives (*.la) from modules directory.
find %{buildroot} -name "*.la" -delete

%if 0
#check
make check|| {
    # find and print the logs of failed test
    # do not cat tests/testsuite.log because it contains a lot of bloat
    cat tests/test-suite.log
    find tests/testsuite.dir -name "testsuite.log" -print -exec cat '{}' \;
    exit 1
}
%endif
%files
%doc README.md NEWS
%doc --no-dereference COPYING
%{_bindir}/satyr
%{_mandir}/man1/%{name}.1*
%{_libdir}/lib*.so.*

%files devel
# The complex pattern below (instead of simlpy *) excludes Makefile.am:
# The complex pattern below (instead of simlpy *) excludes Makefile.in:
%doc apidoc/html/*.html
%doc apidoc/html/*.png
%doc apidoc/html/*.css
%doc apidoc/html/*.js
%{_includedir}/*
%{_libdir}/lib*.so
%{_libdir}/pkgconfig/*

%if 0%{?with_python3}
%files -n python3-module-satyr
%dir %{python3_sitelibdir}/%{name}
%{python3_sitelibdir}/%{name}/*
%endif

%changelog
